#include <solomon/libs/cpp/stockpile_codec/metric_archive.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NStockpile;

namespace {

TBuffer Encode(const TMetricArchive &archive) {
    TCodecOutput out{16};
    TMetricArchiveCodec codec{archive.Format()};
    codec.Encode(archive, &out);
    return out.TakeBuffer();
}

TMetricArchive Decode(EFormat format, const TBuffer &data) {
    TCodecInput in{data};
    TMetricArchiveCodec codec{format};
    return codec.Decode(&in);
}

} // namespace

TEST(TMetricArchiveTest, EncodeDecode) {
    TMetricHeader header;
    header.Owner.ProjectId = 123;
    header.Owner.ShardId = 456;
    header.DeleteBefore = TInstant::ParseIso8601("2020-05-09T10:00:00Z");
    header.DecimPolicyId = 3;
    header.Type = yandex::solomon::model::MetricType::RATE;

    NTs::TColumnSet columns{NTs::EColumn::TS, NTs::EColumn::LONG_VALUE};

    for (EFormat format: {EFormat::HISTOGRAM_DENOM_37, EFormat::DELETED_SHARDS_39}) {
        TMetricArchive archive{header, format, columns, 1, NTs::TBitBuffer::FromString("10101010 101")};
        TMetricArchive decodedArchive = Decode(format, Encode(archive));

        EXPECT_EQ(archive, decodedArchive);
    }
}
