#include <solomon/libs/cpp/stockpile_codec/metric_header.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/string/hex.h>

using namespace NSolomon::NStockpile;

namespace {

TBuffer Encode(const TMetricHeader &header) {
    TCodecOutput out{16};
    TMetricHeaderCodec{}.Encode(header, &out);
    return out.TakeBuffer();
}

TMetricHeader Decode(const TBuffer &data) {
    TCodecInput in{data};
    return TMetricHeaderCodec{}.Decode(&in);
}

} // namespace

TEST(TMetricHeaderTest, EncodeDecode) {
    TMetricHeader header;
    header.Owner = {11, 22};
    header.DeleteBefore = TInstant::MilliSeconds(12345678090);
    header.DecimPolicyId = 33;
    header.Type = yandex::solomon::model::MetricType::DGAUGE;

    TBuffer buf = Encode(header);
    EXPECT_EQ(buf.size(), 10u);

    TMetricHeader decodedHeader = Decode(buf);
    EXPECT_EQ(header, decodedHeader);
}
