#pragma once

#include <util/datetime/base.h>
#include <util/generic/buffer.h>

#include <solomon/libs/cpp/ts_codec/bit_span.h>

#include <jni.h>

namespace NSolomon::NJava {

TBuffer ToBuffer(JNIEnv* jenv, jbyteArray array);
jbyteArray ToByteArray(JNIEnv* jenv, const TBuffer& buf);
jbyteArray ToByteArray(JNIEnv* jenv, NTs::TBitSpan buf);

class TByteArray {
public:
    TByteArray(JNIEnv* jenv, jbyteArray array);
    ~TByteArray();

    jbyte* Data() const noexcept {
        return Data_;
    }

    jsize Size() const noexcept {
        return Size_;
    }

private:
    JNIEnv* Jenv_;
    jbyteArray Array_;
    jbyte* Data_;
    jsize Size_;
};

class TJavaClass {
public:
    TJavaClass(JNIEnv* jenv, const char* className);
    ~TJavaClass();

    jmethodID GetStaticMethod(const char* name, const char* sig);
    jmethodID GetMethod(const char* name, const char* sig);
    jfieldID GetField(const char* name, const char* sig);

protected:
    JNIEnv* Jenv_;
    jclass Class_;
};

class TMetricTypeClass: private TJavaClass {
public:
    explicit TMetricTypeClass(JNIEnv* jenv);

    jobject ForNumber(jint number);
    jint GetNumber(jobject type);

private:
    jmethodID ForNumberMethod_;
    jmethodID GetNumberMethod_;
};

struct TMetricHeaderObject {
    jlong DeleteBefore;
    jint ProjectId;
    jint ShardId;
    jint DecimPolicyId;
    jobject Type;
};

class TMetricHeaderClass: private TJavaClass {
public:
    explicit TMetricHeaderClass(JNIEnv *jenv);

    jobject New(jlong deleteBeforeMillis, jint projectId, jint shardId, jint decimPolicyId, jobject type);
    TMetricHeaderObject Convert(jobject headerObject);

private:
    jmethodID Constructor_;
    jfieldID DeleteBeforeField_;
    jfieldID ProjectIdField_;
    jfieldID ShardIdField_;
    jfieldID DecimPolicyIdField_;
    jfieldID TypeField_;
};

struct TMetricArchiveObject {
    TMetricHeaderObject Header;
    jint ColumnSetMask;
    jobject Buffer;
    jint RecordCount;
    jobject Format;
};

class TMetricArchiveClass: private TJavaClass {
public:
    explicit TMetricArchiveClass(JNIEnv* jenv);

    jobject New(jobject header, jobject format, jint columnSetMask, jobject buffer, jint recordCount);
    TMetricArchiveObject Convert(jobject archiveObject);

private:
    jmethodID Constructor_;
    jfieldID DeleteBeforeField_;
    jfieldID ProjectIdField_;
    jfieldID ShardIdField_;
    jfieldID DecimPolicyIdField_;
    jfieldID TypeField_;
    jfieldID ColumnSetMaskField_;
    jfieldID BufferField_;
    jfieldID RecordCountField_;
    jfieldID FormatField_;
};

class TStockpileFormatClass: private TJavaClass {
public:
    explicit TStockpileFormatClass(JNIEnv* jenv);

    jint Convert(jobject format);

private:
    jfieldID FormatField_;
};

struct THeapBitBufObject {
    jbyteArray Array;
    jlong WriteIndex;
    jlong ReadIndex;
};

class THeapBitBufClass: private TJavaClass {
public:
    explicit THeapBitBufClass(JNIEnv* jenv);

    jobject New(jbyteArray array, jlong lengthBits);
    THeapBitBufObject Convert(jobject bitBufObject);

private:
    jmethodID Constructor_;
    jfieldID ArrayField_;
    jfieldID WriteIndexField_;
    jfieldID ReadIndexField_;
};

} // namespace NSolomon::NJava
