#include "ru_yandex_solomon_MetricHeaderNative.h"
#include "java_objects.h"

#include <solomon/libs/cpp/stockpile_codec/metric_header.h>

using namespace NSolomon;
using namespace NStockpile;

namespace {

TMetricHeader Decode(NJava::TByteArray array) {
    TCodecInput in{array.Data(), static_cast<size_t>(array.Size())};
    TMetricHeaderCodec codec;
    return codec.Decode(&in);
}

TBuffer Encode(const TMetricHeader& header) {
    TCodecOutput out{16};
    TMetricHeaderCodec{}.Encode(header, &out);
    return out.TakeBuffer();
}

} // namespace

jobject Java_ru_yandex_solomon_MetricHeaderNative_decode(JNIEnv* jenv, jclass, jbyteArray buffer) {
    try {
        auto header = Decode(NJava::TByteArray{jenv, buffer});

        NJava::TMetricTypeClass metricTypeClass{jenv};
        jobject type = metricTypeClass.ForNumber(static_cast<jint>(header.Type));

        NJava::TMetricHeaderClass metricHeaderClass{jenv};
        return metricHeaderClass.New(
                static_cast<jlong>(header.DeleteBefore.MilliSeconds()),
                static_cast<jint>(header.Owner.ProjectId),
                static_cast<jint>(header.Owner.ShardId),
                static_cast<jint>(header.DecimPolicyId),
                type);
    } catch (...) {
        TString msg = CurrentExceptionMessage();
        jenv->ThrowNew(jenv->FindClass("java/lang/RuntimeException"), msg.c_str());
        return nullptr;
    }
}

jbyteArray Java_ru_yandex_solomon_MetricHeaderNative_encode(JNIEnv* jenv, jclass, jobject javaHeaderObject) {
    try {
        NJava::TMetricHeaderClass metricHeaderClass{jenv};
        NJava::TMetricHeaderObject javaHeader = metricHeaderClass.Convert(javaHeaderObject);

        NJava::TMetricTypeClass metricTypeClass{jenv};
        jint typeNumber = metricTypeClass.GetNumber(javaHeader.Type);

        TMetricHeader header;
        header.DeleteBefore = TInstant::MilliSeconds(static_cast<ui64>(javaHeader.DeleteBefore));
        header.Owner.ProjectId = static_cast<ui32>(javaHeader.ProjectId);
        header.Owner.ShardId = static_cast<ui32>(javaHeader.ShardId);
        header.DecimPolicyId = static_cast<ui32>(javaHeader.DecimPolicyId);
        header.Type = static_cast<yandex::solomon::model::MetricType>(typeNumber);

        TBuffer buffer = Encode(header);
        return NJava::ToByteArray(jenv, buffer);
    } catch (...) {
        TString msg = CurrentExceptionMessage();
        jenv->ThrowNew(jenv->FindClass("java/lang/RuntimeException"), msg.c_str());
        return nullptr;
    }
}
