#include "ru_yandex_solomon_StockpileFormatNative.h"

#include <solomon/libs/cpp/stockpile_codec/format.h>

#include <vector>

using namespace NSolomon;
using namespace NStockpile;

jintArray Java_ru_yandex_solomon_StockpileFormatNative_getKnownFormatIds(JNIEnv* jenv, jclass) {
    ui32 min = static_cast<ui32>(MinSupportedFormat);
    ui32 max = static_cast<ui32>(MaxSupportedFormat);

    std::vector<jint> formats;
    for (ui32 f = min; f <= max; f++) {
        formats.push_back(static_cast<jint>(f));
    }

    auto len = static_cast<jsize>(formats.size());
    jintArray formatsJava = jenv->NewIntArray(len);
    jenv->SetIntArrayRegion(formatsJava, 0, len, formats.data());
    return formatsJava;
}
