package ru.yandex.solomon;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.codec.archive.header.MetricHeader;
import ru.yandex.solomon.codec.archive.serializer.MetricHeaderSerializer;
import ru.yandex.solomon.codec.serializer.HeapStockpileSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.model.protobuf.MetricType;

public class MetricHeaderTest {

    @Test
    public void decode() {
        var expected = new MetricHeader(System.currentTimeMillis(), 11, 12, 13, MetricType.COUNTER);

        var decoded = MetricHeaderNative.decode(serialize(expected));
        Assert.assertEquals(expected, decoded);
    }

    @Test
    public void encode() {
        var expected = new MetricHeader(System.currentTimeMillis(), 21, 22, 23, MetricType.RATE);

        var javaBuffer = serialize(expected);
        var cppBuffer = MetricHeaderNative.encode(expected);
        Assert.assertArrayEquals(javaBuffer, cppBuffer);

        var encoded = deserialize(cppBuffer);
        Assert.assertEquals(expected, encoded);
    }

    private static byte[] serialize(MetricHeader mh) {
        var ss = new HeapStockpileSerializer();
        MetricHeaderSerializer.I.serializeWithLength(mh, ss);
        return ss.build();
    }

    private static MetricHeader deserialize(byte[] buffer) {
        var sd = new StockpileDeserializer(buffer);
        return MetricHeaderSerializer.I.deserializeWithLength(sd);
    }
}
