package ru.yandex.solomon;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.junit.Test;

import ru.yandex.solomon.codec.serializer.StockpileFormat;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;


public class StockpileFormatTest {

    @Test
    public void cppIdsAreKnown() {
        int[] ids = StockpileFormatNative.getKnownFormatIds();
        for (int id : ids) {
            assertNotNull("cpp format " + id + " is unknown in java code", StockpileFormat.byNumberOrNull(id));
        }
    }

    @Test
    public void javaIdsAreKnown() {
        var cppIds = new IntOpenHashSet(StockpileFormatNative.getKnownFormatIds());
        for (StockpileFormat format : StockpileFormat.values()) {
            assertTrue("java format " + format + " is unknown in cpp code", cppIds.contains(format.getFormat()));
        }
    }
}
