#include <solomon/libs/cpp/string_map/string_map.h>

#include <library/cpp/testing/gtest/gtest.h>

TEST(TStringMapTest, StringBuf) {
    NSolomon::TStringMap<int> map;
    map[TStringBuf{"one"}] = 1;
    map[TStringBuf{"two"}] = 2;

    ASSERT_EQ(map.size(), 2u);

    auto oneIt = map.find(TStringBuf{"one"});
    ASSERT_NE(oneIt, map.end());
    ASSERT_EQ(oneIt->second, 1);

    auto twoIt = map.find(TStringBuf{"two"});
    ASSERT_NE(twoIt, map.end());
    ASSERT_EQ(twoIt->second, 2);

    auto threeIt = map.find(TStringBuf{"three"});
    ASSERT_EQ(threeIt, map.end());
}

TEST(TStringMapTest, StringView) {
    using namespace std::string_view_literals;

    NSolomon::TStringMap<int> map;
    map["one"sv] = 1;
    map["two"sv] = 2;

    ASSERT_EQ(map.size(), 2u);

    auto oneIt = map.find("one"sv);
    ASSERT_NE(oneIt, map.end());
    ASSERT_EQ(oneIt->second, 1);

    auto twoIt = map.find("two"sv);
    ASSERT_NE(twoIt, map.end());
    ASSERT_EQ(twoIt->second, 2);

    auto threeIt = map.find("three"sv);
    ASSERT_EQ(threeIt, map.end());
}
