#!/bin/sh -ex

SRCS="$(find ../src -name '*Native.java')"
LIBS_DIR="../../../../libs/java"

# generate .h files
ya tool javac15 -cp "${LIBS_DIR}/util/util.jar:." \
    -h . $SRCS

# drop created .class files
find ../src -name '*.class' -delete

# add pragma once
find . -name 'ru_*.h' | xargs -n1 sed -i '' '1i\
#pragma once
'

