#include "ru_yandex_solomon_strings_StringPoolNative.h"

#include <solomon/libs/cpp/string_pool/string_pool.h>

using namespace NSolomon;

jbyteArray Java_ru_yandex_solomon_strings_StringPoolNative_encodePool(
        JNIEnv* jenv, jclass, jint compression, jobjectArray stringsArr)
{
    NStringPool::TStringPoolBuilder pool;
    for (jsize i = 0, len = jenv->GetArrayLength(stringsArr); i < len; i++) {
        auto str = reinterpret_cast<jstring>(jenv->GetObjectArrayElement(stringsArr, i));

        jsize strLen = jenv->GetStringUTFLength(str);
        const char* strChars = jenv->GetStringUTFChars(str, nullptr);
        pool.Put({strChars, static_cast<size_t>(strLen)});
        jenv->ReleaseStringUTFChars(str, strChars);
    }

    auto poolProto = pool.Build(static_cast<yandex::solomon::common::StringPool_Compression>(compression));
    TString bytes = poolProto.SerializeAsStringOrThrow();
    auto bytesLen = static_cast<jsize>(bytes.size());

    jbyteArray bytesArr = jenv->NewByteArray(bytesLen);
    jenv->SetByteArrayRegion(bytesArr, 0, bytesLen, reinterpret_cast<const jbyte*>(bytes.data()));
    return bytesArr;
}

jobjectArray Java_ru_yandex_solomon_strings_StringPoolNative_decodePool(JNIEnv* jenv, jclass, jbyteArray bytesArr) {
    yandex::solomon::common::StringPool poolProto;
    jbyte* bytes = jenv->GetByteArrayElements(bytesArr, nullptr);
    jsize bytesLen = jenv->GetArrayLength(bytesArr);
    Y_ENSURE(poolProto.ParseFromArray(bytes, bytesLen), "cannot parse StringPool from bytes");
    jenv->ReleaseByteArrayElements(bytesArr, bytes, JNI_ABORT);

    NStringPool::TStringPool pool{poolProto};
    jobjectArray stringsArr = jenv->NewObjectArray(
            static_cast<jsize>(pool.Size() + 1),
            jenv->FindClass("java/lang/String"),
            jenv->NewStringUTF(""));

    for (ui32 i = 0, size = pool.Size(); i <= size; i++) {
        TString str = TString{pool[i]};
        jstring strJava = jenv->NewStringUTF(str.data());
        jenv->SetObjectArrayElement(stringsArr, i, strJava);
    }

    return stringsArr;
}
