package ru.yandex.solomon.strings;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.common.StringPool.Compression;
import ru.yandex.solomon.util.protobuf.StringPool;

/**
 * @author Sergey Polovko
 */
@RunWith(Parameterized.class)
public class StringPoolDecodeTest {

    @Parameterized.Parameter
    public Compression compression;

    @Parameterized.Parameters(name = "{0}")
    public static Compression[] parameters() {
        return new Compression[] {
            Compression.COMPRESSION_UNSPECIFIED,
            Compression.LZ4,
        };
    }

    @Test
    public void empty() {
        String[] strings = StringPoolNative.decodePool(buildPool());
        Assert.assertArrayEquals(new String[]{""}, strings);
    }

    @Test
    public void nonEmpty() {
        String[] strings = StringPoolNative.decodePool(buildPool("one", "two", "three"));
        Assert.assertArrayEquals(new String[]{"", "one", "two", "three"}, strings);
    }

    @Test
    public void withEmptyStrings() {
        String[] strings = StringPoolNative.decodePool(buildPool("one", "", "two", "", "three"));
        Assert.assertArrayEquals(new String[]{"", "one", "two", "three"}, strings);
    }

    @Test
    public void unicode() {
        String[] strings = StringPoolNative.decodePool(buildPool("один", "ένας", "два", "δύο"));
        Assert.assertArrayEquals(new String[]{"", "один", "ένας", "два", "δύο"}, strings);
    }

    private byte[] buildPool(String... strings) {
        var builder = StringPool.newBuilder();
        for (String s : strings) {
            builder.put(s);
        }
        return builder.buildProto(compression).toByteArray();
    }
}
