package ru.yandex.solomon.strings;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.common.StringPool.Compression;
import ru.yandex.solomon.util.protobuf.StringPool;

/**
 * @author Sergey Polovko
 */
@RunWith(Parameterized.class)
public class StringPoolEncodeTest {

    @Parameterized.Parameter
    public Compression compression;

    @Parameterized.Parameters(name = "{0}")
    public static Compression[] parameters() {
        return new Compression[] {
            Compression.COMPRESSION_UNSPECIFIED,
            Compression.LZ4,
        };
    }

    @Test
    public void empty() throws Exception {
        byte[] bytes = StringPoolNative.encodePool(compression.getNumber());
        var pool = StringPool.fromProto(ru.yandex.solomon.common.StringPool.parseFrom(bytes));

        Assert.assertEquals(0, pool.size());
        Assert.assertEquals("", pool.get(0));
    }

    @Test
    public void nonEmpty() throws Exception {
        byte[] bytes = StringPoolNative.encodePool(compression.getNumber(), "one", "two", "three");
        var pool = StringPool.fromProto(ru.yandex.solomon.common.StringPool.parseFrom(bytes));

        Assert.assertEquals(3, pool.size());
        Assert.assertEquals("", pool.get(0));
        Assert.assertEquals("one", pool.get(1));
        Assert.assertEquals("two", pool.get(2));
        Assert.assertEquals("three", pool.get(3));
    }

    @Test
    public void withEmptyStrings() throws Exception {
        byte[] bytes = StringPoolNative.encodePool(compression.getNumber(), "one", "", "two", "", "three");
        var pool = StringPool.fromProto(ru.yandex.solomon.common.StringPool.parseFrom(bytes));

        Assert.assertEquals(3, pool.size());
        Assert.assertEquals("", pool.get(0));
        Assert.assertEquals("one", pool.get(1));
        Assert.assertEquals("two", pool.get(2));
        Assert.assertEquals("three", pool.get(3));
    }

    @Test
    public void unicode() throws Exception {
        byte[] bytes = StringPoolNative.encodePool(compression.getNumber(), "один", "ένας", "два", "δύο");
        var pool = StringPool.fromProto(ru.yandex.solomon.common.StringPool.parseFrom(bytes));

        Assert.assertEquals(4, pool.size());
        Assert.assertEquals("", pool.get(0));
        Assert.assertEquals("один", pool.get(1));
        Assert.assertEquals("ένας", pool.get(2));
        Assert.assertEquals("два", pool.get(3));
        Assert.assertEquals("δύο", pool.get(4));
    }
}
