#pragma once

#include <util/generic/noncopyable.h>

namespace NSolomon::NSync {

template <typename T, typename TGuard>
struct TAccessConst: public TMoveOnly {
    template <typename TLock>
    TAccessConst(const T* data, TLock* lock) noexcept
        : Data_{data}
        , Guard_{lock}
    {
    }

    explicit inline operator bool() const noexcept {
        return Guard_.WasAcquired();
    }

    const T& operator*() const noexcept {
        return *Data_;
    }

    const T* operator->() const noexcept {
        return Data_;
    }

private:
    const T* Data_;
    TGuard Guard_;
};

template <typename T, typename TGuard>
struct TAccessMut: public TMoveOnly {
    template <typename TLock>
    TAccessMut(T* data, TLock* lock) noexcept
        : Data_{data}
        , Guard_{lock}
    {
    }

    explicit inline operator bool() const noexcept {
        return Guard_.WasAcquired();
    }

    T& operator*() noexcept {
        return *Data_;
    }

    T* operator->() noexcept {
        return Data_;
    }

private:
    T* Data_;
    TGuard Guard_;
};

} // namespace NSolomon::NSync
