#include <solomon/libs/cpp/sync/lock.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

TEST(TLockTest, Lock) {
    NSync::TLock<int> val = 42;

    auto v = val.Lock();
    ASSERT_TRUE(v);
    ASSERT_EQ(*v, 42);

    *v = 57;
    ASSERT_EQ(*v, 57);
}

TEST(TLockTest, TryLock) {
    NSync::TAdaptiveLock<int> val = 42;

    auto v1 = val.TryLock();
    ASSERT_TRUE(v1);
    ASSERT_EQ(*v1, 42);

    // cannot access already locked value
    auto v2 = val.TryLock();
    ASSERT_FALSE(v2);
}

TEST(TLockTest, ComplexTypes) {
    {
        NSync::TLock<TString> str = "initialized from char*";
        ASSERT_EQ(*str.Lock(), "initialized from char*");
    }
    {
        NSync::TLock<TString> str = TStringBuf{"initialized from string buf"};
        ASSERT_EQ(*str.Lock(), "initialized from string buf");
    }
    {
        NSync::TLock<TString> str = TString{"initialized from string"};
        ASSERT_EQ(*str.Lock(), "initialized from string");
    }
    {
        using TMyMap = std::map<int, TString>;
        NSync::TLock<TMyMap> map = TMyMap{
                {1, "one"},
                {2, "two"},
                {3, "three"},
        };

        if (auto r = map.Lock()) {
            ASSERT_EQ(r->size(), 3u);
            ASSERT_EQ(r->at(1), "one");

            auto it = r->find(2);
            ASSERT_NE(it, r->end());
            ASSERT_EQ(it->second, "two");
        } else {
            FAIL() << "failed to acquire lock";
        }
    }
}

TEST(TLockTest, DefaultConstructable) {
    NSync::TLock<TInstant> val;

    auto v = val.Lock();
    ASSERT_TRUE(v);
    ASSERT_EQ(*v, TInstant::Zero());
}
