#pragma once

#include <solomon/libs/cpp/sysmon/proto/sysmon_metrics.pb.h>

#include <util/folder/path.h>

namespace NSolomon {
    static inline TFsPath DefaultProcDirectory = TFsPath("/proc");
    static inline TFsPath DefaultSysDirectory = TFsPath("/sys");

    Sysmon FillSysmon(const TFsPath& procDirectory = DefaultProcDirectory,
                      const TFsPath& sysDirectory = DefaultSysDirectory);
    void ProcNet(SysmonNet* net, const TFsPath& procDirectory = DefaultProcDirectory);

    void ProcFilesystem(Sysmon* sysmon, const TFsPath& mountInfoPath = DefaultProcDirectory / "self/mountinfo");
    void ProcDiskstats(Sysmon* sysmon, const TFsPath& procDirectory = DefaultProcDirectory);
    void ProcMemory(Sysmon* sysmon, const TFsPath& procDirectory = DefaultProcDirectory);
    void ProcKernel(Sysmon* sysmon, const TFsPath& procDirectory = DefaultProcDirectory);
    void ProcCpuinfo(Sysmon* sysmon, const TFsPath& procDirectory = DefaultProcDirectory);
    void ProcNuma(Sysmon* sysmon, const TFsPath& sysDirectory = DefaultSysDirectory);
    void ProcStatSystem(Sysmon* sysmon, const TFsPath& procDirectory);
    void ProcStatCpu(Sysmon* sysmon, const TFsPath& procDirectory = DefaultProcDirectory);

    // only /proc/net/dev
    void ProcNetBasic(Sysmon* sysmon, const TFsPath& procDirectory = DefaultProcDirectory);
    // more stuff available from /proc/net (netstat, snmp)
    void ProcNetAdvanced(Sysmon* sysmon, const TFsPath& procDirectory = DefaultProcDirectory);

} // namespace NSolomon
