#pragma once

#include <library/cpp/monlib/metrics/metric.h>

#include <util/thread/pool.h>

namespace NSolomon {

class IThreadPoolStatusListener {
public:
    virtual ~IThreadPoolStatusListener() = default;
    virtual void OnStart(size_t threadCount, size_t queueSizeLimit) noexcept = 0;
    virtual void OnTaskScheduled() noexcept = 0;
    virtual void OnTaskRejected() noexcept = 0;
    virtual void OnTaskBeforeExecution(TDuration waitTime) noexcept = 0;
    virtual void OnTaskCompleted(TDuration executionTime) noexcept = 0;
    virtual void OnStop() noexcept = 0;
};

using IThreadPoolStatusListenerPtr = std::shared_ptr<IThreadPoolStatusListener>;

std::shared_ptr<IThreadPool> CreateThreadPool(
        size_t threadCount,
        size_t queueSizeLimit = 0,
        const TThreadPool::TParams& params = TThreadPool::TParams(),
        IThreadPoolStatusListenerPtr statusListener = nullptr);

std::shared_ptr<IThreadPool> CreateThreadPoolProxy(
        IThreadPool* pool,
        IThreadPoolStatusListenerPtr statusListener = nullptr);

std::unique_ptr<IThreadPool> CreateThreadPoolProxyUnique(
    std::unique_ptr<IThreadPool> pool,
    IThreadPoolStatusListenerPtr statusListener = nullptr);

} // namespace NSolomon
