#pragma once

#include <memory>

#include <util/system/type_name.h>

namespace NSolomon::NTracing {

class IUdpSender {
public:
    virtual bool Send(const char*, int) = 0;
    virtual ~IUdpSender() = default;
};

// Dumps to localhost:port
// Expects to be called from actorsystem
// Use port = 0 for a stub sender
std::unique_ptr<IUdpSender> MakeUdpSender(ui16 port);

}
