#include "bit_span.h"

#include <ostream>

namespace NSolomon::NTs {

bool TBitSpan::operator==(const TBitSpan& rhs) const noexcept {
    if (Size_ != rhs.Size_) {
        return false;
    }
    if (Data_ == rhs.Data_) {
        return true;
    }

    size_t bytes = Size_ >> 3;
    if (std::memcmp(Data_, rhs.Data_, bytes) != 0) {
        return false;
    }

    size_t lastBits = Size_ & 7;
    if (Y_LIKELY(lastBits == 0)) {
        return true;
    }

    ui8 left = static_cast<const ui8*>(Data_)[bytes];
    ui8 right = static_cast<const ui8*>(rhs.Data_)[bytes];
    return LowerBits(left, lastBits) == LowerBits(right, lastBits);
}

std::ostream& operator<<(std::ostream& out, TBitSpan span) {
    using namespace std::literals;

    return out << "{Data="sv << (void*) span.Data_ << ", Size="sv << span.Size_ << '}';
}

} // namespace NSolomon::NTs
