#include "bit_writer.h"

namespace NSolomon::NTs {
namespace {

template <typename T>
void WriteVarInt(TBitWriter* w, T value) {
    while (value >= 0x80) {
        w->WriteInt8(static_cast<ui8>(value | 0x80));
        value >>= 7;
    }
    w->WriteInt8(static_cast<ui8>(value));
}

} // namespace

void TBitWriter::WriteVarInt32(ui32 value) noexcept {
    WriteVarInt(this, value);
}

void TBitWriter::WriteVarInt64(ui64 value) noexcept {
    WriteVarInt(this, value);
}

void TBitWriter::WriteVarInt32Mode(ui32 value) {
    if (value == 0) {
        WriteBit(false);
    } else if ((value & ~0x0fu) == 0) {
        WriteInt32(value << 2 | 1, 6);
    } else if ((value & ~0xffu) == 0) {
        WriteInt32(value << 3 | 3, 11);
    } else if ((value & ~0x0fffu) == 0) {
        WriteInt32(value << 4 | 7, 16);
    } else {
        WriteInt64(ui64(value) << 5 | 15, 37);
    }
}

void TBitWriter::WriteVarInt64Mode(ui64 value) {
    if (value == 0) {
        WriteBit(false);
    } else if ((value & ~ui64(0x0f)) == 0) {
        WriteInt64(value << 2 | 1, 6);
    } else if ((value & ~ui64(0xff)) == 0) {
        WriteInt64(value << 3 | 3, 11);
    } else if ((value & ~ui64(0x0fff)) == 0) {
        WriteInt64(value << 4 | 7, 16);
    } else if ((value & ~ui64(0xffff)) == 0) {
        WriteInt64(value << 5 | 15, 21);
    } else if ((value & ~ui64(0xffffffull)) == 0) {
        WriteInt64(value << 6 | 31, 30);
    } else if ((value & ~ui64(0xffffffffull)) == 0) {
        WriteInt64(value << 7 | 63, 39);
    } else {
        WriteInt8(0x7f);
        WriteInt64(value);
    }
}

} // namespace NSolomon::NTs
