#include "columns.h"

#include <util/string/cast.h>
#include <util/stream/output.h>

namespace NSolomon::NTs {

const std::array<EColumn, 11> TColumnSet::AllColumns = {
    EColumn::TS,
    EColumn::VALUE,
    EColumn::MERGE,
    EColumn::COUNT,
    EColumn::STEP,
    EColumn::RESERVED_DO_NOT_USE, // vacant position
    EColumn::HISTOGRAM,
    EColumn::LOG_HISTOGRAM,
    EColumn::ISUMMARY,
    EColumn::DSUMMARY,
    EColumn::LONG_VALUE,
};

const TColumnsMask TColumnSet::MaxMask = CombineMask(AllColumns);

std::ostream& operator<<(std::ostream& os, const TColumnSet& set) {
    return os << ToString(set);
}

} // namespace NSolomon::NTs


using NSolomon::NTs::TColumnSet;

template <>
void Out<TColumnSet>(IOutputStream& out, TColumnSet cs) {
    auto mask = cs.Mask();
    bool first = true;

    out << '{';
    while (mask != 0) {
        if (first) {
            first = false;
        } else {
            out << TStringBuf(", ");
        }

        auto idx = LeastSignificantBit(mask);
        Y_ASSERT(idx < TColumnSet::AllColumns.size());
        out << TColumnSet::AllColumns[idx];

        mask &= (mask - 1);
    }
    out << '}';
}
