#pragma once

#include "bit_reader.h"
#include "bit_writer.h"

namespace NSolomon::NTs {

/**
 * Count field encoder.
 */
class TCountEncoder {
public:
    void Encode(TBitWriter* writer, ui64 count) {
        Y_ENSURE(count <= Max<i64>(), "invalid count value: " << count);
        if (Y_UNLIKELY(Prev_ == -1)) {
            writer->WriteVarInt64(count);
        } else {
            ui64 delta = ZigZagEncode64(static_cast<i64>(count) - Prev_);
            writer->WriteVarInt64Mode(delta);
        }
        Prev_ = static_cast<i64>(count);
    }

    i64 Prev() const noexcept {
        return Prev_;
    }

private:
    i64 Prev_{-1};
};

/**
 * Count field decoder.
 */
class TCountDecoder {
public:
    ui64 Decode(TBitReader* reader) {
        if (Y_UNLIKELY(Prev_ == -1)) {
            auto count = reader->ReadVarInt64();
            Y_ENSURE(count, "cannot read first count");
            Y_ENSURE(*count <= Max<i64>(), "invalid count value: " << *count);
            return Prev_ = static_cast<i64>(*count);
        }

        auto delta = reader->ReadVarInt64Mode();
        Y_ENSURE(delta, "cannot read count delta");

        Prev_ += ZigZagDecode64(*delta);
        Y_ENSURE(Prev_ >= 0, "count overflow: " << Prev_);

        return Prev_;
    }

private:
    i64 Prev_{-1};
};

} // namespace NSolomon::NTs
