#pragma once

#include "bit_reader.h"
#include "bit_writer.h"

namespace NSolomon::NTs {

/**
 * Read and decode value denominator from bit stream.
 *
 * @param reader  bit reader
 * @return value denominator
 */
ui64 DenomDecode(TBitReader* reader);

/**
 * Encode and write value denominator to bit stream.
 * @param writer   bit writer
 * @param denom    value denominator
 */
void DenomEncode(TBitWriter* writer, ui64 denom);

} // namespace NSolomon::NTs
