#include "frame_codec.h"

namespace NSolomon::NTs {

bool TFrameDecoder::Next(TBitReader* reader) {
    if (!HasNext(reader)) {
        return false;
    }

    if (Y_UNLIKELY(HeaderIdx_ == -1)) {
        HeaderIdx_ = reader->Pos();
    } else {
        HeaderIdx_ = FooterIdx_ + FRAME_FOOTER_SIZE + FooterBits_;
        reader->SetPos(HeaderIdx_);
    }

    Y_ENSURE(reader->Left() >= FRAME_HEADER_SIZE,
             "cannot read frame header, left(" << reader->Left() << ") < " << FRAME_HEADER_SIZE);

    ui32 payloadBits = static_cast<size_t>(reader->ReadInt32()) << 3;
    ui8 bitsInLastByte = reader->ReadInt8();

    if (Y_UNLIKELY(payloadBits == 0)) {
        PayloadBits_ = reader->Left();
        FooterIdx_ = -1;
        FooterBits_ = -1;
    } else {
        PayloadBits_ = payloadBits;
        if (bitsInLastByte != 0) {
            PayloadBits_ += bitsInLastByte;
            PayloadBits_ -= BitsSize<ui8>();
        }

        FooterIdx_ = HeaderIdx_ + FRAME_HEADER_SIZE + payloadBits;
        reader->SetPos(static_cast<size_t>(FooterIdx_));

        Y_ENSURE(reader->Left() >= FRAME_FOOTER_SIZE,
                 "cannot read frame footer, left(" << reader->Left() << ") < " << FRAME_FOOTER_SIZE);
        FooterBits_ = static_cast<size_t>(reader->ReadInt32()) << 3;
    }
    return true;
}

} // namespace NSolomon::NTs
