#pragma once

#include "bit_reader.h"
#include "bit_writer.h"

namespace NSolomon::NTs {

/**
 * Encoder for double values.
 * Based on Gorilla white paper http://www.vldb.org/pvldb/vol8/p1816-teller.pdf
 */
class TGorillaEncoder {
public:
    void Encode(TBitWriter* writer, double value);

    void WriteState(TBitWriter* writer) {
        writer->WriteDouble(Prev_);
        Prev_ = 0.0;

        // XXX: different order of leading and trailing zeros here and in TDoubleTsEncoder,
        //      kept for backward compatibility with Java library

        writer->WriteInt8(PrevTrailingZeros_);
        PrevTrailingZeros_ = 0;

        writer->WriteInt8(PrevLeadingZeros_);
        PrevLeadingZeros_ = 0;
    }

    double Prev() const noexcept {
        return Prev_;
    }

private:
    double Prev_{0.0};
    ui8 PrevTrailingZeros_{0};
    ui8 PrevLeadingZeros_{0};
};

/**
 * Decoder for double values.
 * Based on Gorilla white paper http://www.vldb.org/pvldb/vol8/p1816-teller.pdf
 */
class TGorillaDecoder {
public:
    double Decode(TBitReader* reader);

    double Prev() const noexcept {
        return Prev_;
    }

private:
    double Prev_{0.0};
    ui8 PrevTrailingZeros_{0};
    ui8 PrevLeadingZeros_{0};
};


} // namespace NSolomon::NTs
