#pragma once

#include "bits.h"

#include <util/system/types.h>

namespace NSolomon::NTs {

/**
 * Summary value fields mask.
 */
class TSummaryMask {
    enum {
        SM_COUNT = 0u,
        SM_SUM = 1u,
        SM_MIN = 2u,
        SM_MAX = 3u,
        SM_LAST = 4u,
    };
public:
    constexpr TSummaryMask() noexcept = default;

    constexpr explicit TSummaryMask(ui8 mask) noexcept
        : Mask_{mask}
    {
    }

    constexpr bool HasCount() const noexcept {
        return BitTest<SM_COUNT>(Mask_);
    }

    constexpr void SetCount() noexcept {
        Mask_ = BitSet<SM_COUNT>(Mask_);
    }

    constexpr bool HasSum() const noexcept {
        return BitTest<SM_SUM>(Mask_);
    }

    constexpr void SetSum() noexcept {
        Mask_ = BitSet<SM_SUM>(Mask_);
    }

    constexpr bool HasMin() const noexcept {
        return BitTest<SM_MIN>(Mask_);
    }

    constexpr void SetMin() noexcept {
        Mask_ = BitSet<SM_MIN>(Mask_);
    }

    constexpr bool HasMax() const noexcept {
        return BitTest<SM_MAX>(Mask_);
    }

    constexpr void SetMax() noexcept {
        Mask_ = BitSet<SM_MAX>(Mask_);
    }

    constexpr bool HasLast() const noexcept {
        return BitTest<SM_LAST>(Mask_);
    }

    constexpr void SetLast() noexcept {
        Mask_ = BitSet<SM_LAST>(Mask_);
    }

    operator ui8() const noexcept {
        return Mask_;
    }

    friend constexpr bool operator==(TSummaryMask rhs, TSummaryMask lhs) noexcept {
        return rhs.Mask_ == lhs.Mask_;
    }

    friend constexpr bool operator!=(TSummaryMask rhs, TSummaryMask lhs) noexcept {
        return !(rhs == lhs);
    }

    friend constexpr TSummaryMask operator&(TSummaryMask rhs, TSummaryMask lhs) noexcept {
        return TSummaryMask{static_cast<ui8>(rhs.Mask_ & lhs.Mask_)};
    }

    friend constexpr TSummaryMask operator|(TSummaryMask rhs, TSummaryMask lhs) noexcept {
        return TSummaryMask{static_cast<ui8>(rhs.Mask_ | lhs.Mask_)};
    }

private:
    ui8 Mask_{0};
};

} // namespace NSolomon::NTs

Y_DECLARE_PODTYPE(NSolomon::NTs::TSummaryMask);
