#pragma once

#include "bit_reader.h"
#include "bit_writer.h"

#include <util/datetime/base.h>

namespace NSolomon::NTs {

/**
 * Time field encoder.
 */
class TTimeEncoder {
public:
    void Encode(TBitWriter* writer, TInstant time);

    TInstant Prev() const noexcept {
        return Prev_;
    }

    i64 DeltaMillis() const noexcept {
        return DeltaMillis_;
    }

    bool Millis() const noexcept {
        return Millis_;
    }

private:
    TInstant Prev_;
    i64 DeltaMillis_{-1};
    bool Millis_{false};
};

/**
 * Time field decoder.
 */
class TTimeDecoder {
public:
    TInstant Decode(TBitReader* reader);

private:
    TInstant Prev_;
    TInstant PrevPrev_;
    bool Millis_{false};
};

} // namespace NSolomon::NTs
