#include <solomon/libs/cpp/ts_codec/bit_span.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <bitset>

using namespace NSolomon;
using namespace NTs;

TEST(TBitSpanTest, Empty) {
    TBitSpan bs;

    EXPECT_EQ(bs.Data(), nullptr);
    EXPECT_EQ(bs.Size(), size_t{0});
}

TEST(TBitSpanTest, NonEmpty) {
    TStringBuf str{"some string"};
    TBitSpan bs{str};

    EXPECT_EQ(bs.Data(), reinterpret_cast<const ui8*>(str.Data()));
    EXPECT_EQ(bs.Size(), str.Size() * 8);
}

TEST(TBitSpanTest, IndexOperator) {
    TString appleStr{"apple"};
    TBitSpan apple{appleStr};

    std::bitset<40> expected("0110010101101100011100000111000001100001");
    for (size_t i = 0; i < apple.Size(); i++) {
        ASSERT_EQ(apple[i], bool(expected[i])) << "i=" << i;
    }
}

TEST(TBitSpanTest, Equality) {
    TString appleStr{"apple"};
    TBitSpan apple{appleStr};

    EXPECT_EQ(apple, apple);
    EXPECT_EQ(apple, TBitSpan{apple});
    EXPECT_EQ(TBitSpan{apple}, apple);

    TString orangeStr{"orange"};
    TBitSpan orange{orangeStr};
    EXPECT_NE(apple, orange);
    EXPECT_NE(orange, apple);

    TBitSpan apple2{"apple"};
    EXPECT_EQ(apple, apple2);
    EXPECT_EQ(apple2, apple);
}

TEST(TBitSpanTest, EqualityBits) {
    TString appleStr{"apple"};
    TString appleStrCopy = appleStr.copy();

    for (size_t len = appleStr.size() * 8; len != 0; len--) {
        TBitSpan apple{appleStr.data(), len-1};
        TBitSpan appleCopy{appleStrCopy.data(), len-1};
        EXPECT_EQ(apple, appleCopy) << "len=" << len-1;
    }
}
