#include <solomon/libs/cpp/ts_codec/bits.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

TEST(TBitsTest, BitsSize) {
    EXPECT_EQ(NTs::BitsSize<ui8>(), 8u);
    EXPECT_EQ(NTs::BitsSize<i8>(), 8u);
    EXPECT_EQ(NTs::BitsSize<ui16>(), 16u);
    EXPECT_EQ(NTs::BitsSize<i16>(), 16u);
    EXPECT_EQ(NTs::BitsSize<ui32>(), 32u);
    EXPECT_EQ(NTs::BitsSize<i32>(), 32u);
    EXPECT_EQ(NTs::BitsSize<ui64>(), 64u);
    EXPECT_EQ(NTs::BitsSize<i64>(), 64u);
}

TEST(TBitsTest, Test) {
    EXPECT_FALSE(NTs::BitTest<0>(0xaa));
    EXPECT_TRUE(NTs::BitTest<1>(0xaa));
    EXPECT_FALSE(NTs::BitTest<2>(0xaa));
    EXPECT_TRUE(NTs::BitTest<3>(0xaa));
    EXPECT_FALSE(NTs::BitTest<4>(0xaa));
    EXPECT_TRUE(NTs::BitTest<5>(0xaa));
    EXPECT_FALSE(NTs::BitTest<6>(0xaa));
    EXPECT_TRUE(NTs::BitTest<7>(0xaa));
}

TEST(TBitsTest, Set) {
    EXPECT_EQ(NTs::BitSet<0>(0), 0b00000001);
    EXPECT_EQ(NTs::BitSet<1>(0), 0b00000010);
    EXPECT_EQ(NTs::BitSet<2>(0), 0b00000100);
    EXPECT_EQ(NTs::BitSet<3>(0), 0b00001000);
    EXPECT_EQ(NTs::BitSet<4>(0), 0b00010000);
    EXPECT_EQ(NTs::BitSet<5>(0), 0b00100000);
    EXPECT_EQ(NTs::BitSet<6>(0), 0b01000000);
    EXPECT_EQ(NTs::BitSet<7>(0), 0b10000000);
}

TEST(TBitsTest, Clear) {
    EXPECT_EQ(NTs::BitClear<0>(0xff), 0b11111110);
    EXPECT_EQ(NTs::BitClear<1>(0xff), 0b11111101);
    EXPECT_EQ(NTs::BitClear<2>(0xff), 0b11111011);
    EXPECT_EQ(NTs::BitClear<3>(0xff), 0b11110111);
    EXPECT_EQ(NTs::BitClear<4>(0xff), 0b11101111);
    EXPECT_EQ(NTs::BitClear<5>(0xff), 0b11011111);
    EXPECT_EQ(NTs::BitClear<6>(0xff), 0b10111111);
    EXPECT_EQ(NTs::BitClear<7>(0xff), 0b01111111);
}

TEST(TBitsTest, SplitIndex) {
    EXPECT_EQ(NTs::SplitBitIndex(128), std::pair(16ul, 0ul));
    EXPECT_EQ(NTs::SplitBitIndex(129), std::pair(16ul, 1ul));
    EXPECT_EQ(NTs::SplitBitIndex(130), std::pair(16ul, 2ul));
    EXPECT_EQ(NTs::SplitBitIndex(131), std::pair(16ul, 3ul));
    EXPECT_EQ(NTs::SplitBitIndex(132), std::pair(16ul, 4ul));
    EXPECT_EQ(NTs::SplitBitIndex(133), std::pair(16ul, 5ul));
    EXPECT_EQ(NTs::SplitBitIndex(134), std::pair(16ul, 6ul));
    EXPECT_EQ(NTs::SplitBitIndex(135), std::pair(16ul, 7ul));
    EXPECT_EQ(NTs::SplitBitIndex(136), std::pair(17ul, 0ul));
}

TEST(TBitsTest, LowerBits) {
    EXPECT_EQ(NTs::LowerBits(0xffffu, 0), 0x0000u);
    EXPECT_EQ(NTs::LowerBits(0xffffu, 1), 0x0001u);
    EXPECT_EQ(NTs::LowerBits(0xffffu, 2), 0x0003u);
    EXPECT_EQ(NTs::LowerBits(0xffffu, 3), 0x0007u);
    EXPECT_EQ(NTs::LowerBits(0xffffu, 4), 0x000fu);
    EXPECT_EQ(NTs::LowerBits(0xffffu, 5), 0x001fu);
    EXPECT_EQ(NTs::LowerBits(0xffffu, 6), 0x003fu);
    EXPECT_EQ(NTs::LowerBits(0xffffu, 7), 0x007fu);
    EXPECT_EQ(NTs::LowerBits(0xffffu, 8), 0x00ffu);
}

TEST(TBitsTest, ByteCount) {
    EXPECT_EQ(NTs::ByteCount(0), 0u);
    EXPECT_EQ(NTs::ByteCount(1), 1u);
    EXPECT_EQ(NTs::ByteCount(2), 1u);
    EXPECT_EQ(NTs::ByteCount(3), 1u);
    EXPECT_EQ(NTs::ByteCount(4), 1u);
    EXPECT_EQ(NTs::ByteCount(5), 1u);
    EXPECT_EQ(NTs::ByteCount(6), 1u);
    EXPECT_EQ(NTs::ByteCount(7), 1u);
    EXPECT_EQ(NTs::ByteCount(8), 1u);
    EXPECT_EQ(NTs::ByteCount(9), 2u);
}

TEST(TBitsTest, AlignToByte) {
    EXPECT_EQ(NTs::AlignToByte(0), 0u);
    EXPECT_EQ(NTs::AlignToByte(1), 8u);
    EXPECT_EQ(NTs::AlignToByte(2), 8u);
    EXPECT_EQ(NTs::AlignToByte(3), 8u);
    EXPECT_EQ(NTs::AlignToByte(4), 8u);
    EXPECT_EQ(NTs::AlignToByte(5), 8u);
    EXPECT_EQ(NTs::AlignToByte(6), 8u);
    EXPECT_EQ(NTs::AlignToByte(7), 8u);
    EXPECT_EQ(NTs::AlignToByte(8), 8u);
    EXPECT_EQ(NTs::AlignToByte(9), 16u);
}

TEST(TBitsTest, ZigZagEncode32) {
    EXPECT_EQ(NTs::ZigZagEncode32(0), 0u);
    EXPECT_EQ(NTs::ZigZagEncode32(-1), 1u);
    EXPECT_EQ(NTs::ZigZagEncode32(1), 2u);
    EXPECT_EQ(NTs::ZigZagEncode32(-2), 3u);
    EXPECT_EQ(NTs::ZigZagEncode32(2), 4u);
    EXPECT_EQ(NTs::ZigZagEncode32(-3), 5u);
    EXPECT_EQ(NTs::ZigZagEncode32(3), 6u);
    EXPECT_EQ(NTs::ZigZagEncode32(-4), 7u);
    EXPECT_EQ(NTs::ZigZagEncode32(4), 8u);
}

TEST(TBitsTest, ZigZagDecode32) {
    EXPECT_EQ(NTs::ZigZagDecode32(0), 0);
    EXPECT_EQ(NTs::ZigZagDecode32(1), -1);
    EXPECT_EQ(NTs::ZigZagDecode32(2), 1);
    EXPECT_EQ(NTs::ZigZagDecode32(3), -2);
    EXPECT_EQ(NTs::ZigZagDecode32(4), 2);
    EXPECT_EQ(NTs::ZigZagDecode32(5), -3);
    EXPECT_EQ(NTs::ZigZagDecode32(6), 3);
    EXPECT_EQ(NTs::ZigZagDecode32(7), -4);
    EXPECT_EQ(NTs::ZigZagDecode32(8), 4);
}

TEST(TBitsTest, ZigZagEncode64) {
    EXPECT_EQ(NTs::ZigZagEncode64(0), 0u);
    EXPECT_EQ(NTs::ZigZagEncode64(-1), 1u);
    EXPECT_EQ(NTs::ZigZagEncode64(1), 2u);
    EXPECT_EQ(NTs::ZigZagEncode64(-2), 3u);
    EXPECT_EQ(NTs::ZigZagEncode64(2), 4u);
    EXPECT_EQ(NTs::ZigZagEncode64(-3), 5u);
    EXPECT_EQ(NTs::ZigZagEncode64(3), 6u);
    EXPECT_EQ(NTs::ZigZagEncode64(-4), 7u);
    EXPECT_EQ(NTs::ZigZagEncode64(4), 8u);
}

TEST(TBitsTest, ZigZagDecode64) {
    EXPECT_EQ(NTs::ZigZagDecode64(0), 0);
    EXPECT_EQ(NTs::ZigZagDecode64(1), -1);
    EXPECT_EQ(NTs::ZigZagDecode64(2), 1);
    EXPECT_EQ(NTs::ZigZagDecode64(3), -2);
    EXPECT_EQ(NTs::ZigZagDecode64(4), 2);
    EXPECT_EQ(NTs::ZigZagDecode64(5), -3);
    EXPECT_EQ(NTs::ZigZagDecode64(6), 3);
    EXPECT_EQ(NTs::ZigZagDecode64(7), -4);
    EXPECT_EQ(NTs::ZigZagDecode64(8), 4);
}
