#include <solomon/libs/cpp/ts_codec/columns.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/string/cast.h>

using namespace NSolomon::NTs;

TEST(TColumnsTest, EmptySet) {
    TColumnSet empty;
    EXPECT_EQ(empty.Mask(), 0);
    for (EColumn c: TColumnSet::AllColumns) {
        EXPECT_FALSE(empty.IsSet(c));
    }
}

TEST(TColumnsTest, NonEmptySet) {
    for (EColumn c: TColumnSet::AllColumns) {
        if (c == EColumn::RESERVED_DO_NOT_USE) {
            continue;
        }

        TColumnSet set{c};
        EXPECT_EQ(set.Mask(), ui16(1) << static_cast<ui8>(c));

        for (EColumn d: TColumnSet::AllColumns) {
            if (d == EColumn::RESERVED_DO_NOT_USE) {
                continue;
            }

            if (c == d) {
                EXPECT_TRUE(set.IsSet(d));
            } else {
                EXPECT_FALSE(set.IsSet(d));
            }
        }
    }
}

TEST(TColumnsTest, ToString) {
    EXPECT_EQ("{}", ToString(TColumnSet{}));
    EXPECT_EQ("{TS}", ToString(TColumnSet{EColumn::TS}));
    EXPECT_EQ("{VALUE}", ToString(TColumnSet{EColumn::VALUE}));
    EXPECT_EQ("{STEP}", ToString(TColumnSet{EColumn::STEP}));
    EXPECT_EQ("{LONG_VALUE}", ToString(TColumnSet{EColumn::LONG_VALUE}));
    EXPECT_EQ("{TS, VALUE}", ToString(TColumnSet{EColumn::TS, EColumn::VALUE}));
    EXPECT_EQ("{TS, HISTOGRAM}", ToString(TColumnSet{EColumn::TS, EColumn::HISTOGRAM}));
    EXPECT_EQ("{STEP, LONG_VALUE}", ToString(TColumnSet{EColumn::STEP, EColumn::LONG_VALUE}));
    EXPECT_EQ("{TS, VALUE, COUNT}", ToString(TColumnSet{EColumn::TS, EColumn::VALUE, EColumn::COUNT}));

    EXPECT_EQ(
            "{TS, VALUE, MERGE, COUNT, STEP, HISTOGRAM, LOG_HISTOGRAM, ISUMMARY, DSUMMARY, LONG_VALUE}",
            ToString(TColumnSet{TColumnSet::MaxMask}));
}

TEST(TColumnsTest, Union) {
    TColumnSet set = TColumnSet{EColumn::TS, EColumn::VALUE} | TColumnSet{EColumn::VALUE, EColumn::STEP};
    TColumnSet expected = TColumnSet{EColumn::TS, EColumn::STEP, EColumn::VALUE};
    EXPECT_EQ(set, expected);
}

TEST(TColumnsTest, Intersection) {
    TColumnSet set =
            TColumnSet{EColumn::TS, EColumn::VALUE, EColumn::STEP} &
            TColumnSet{EColumn::VALUE, EColumn::TS, EColumn::MERGE};
    TColumnSet expected = TColumnSet{EColumn::TS, EColumn::VALUE};
    EXPECT_EQ(set, expected);
}
