#pragma once

#include <solomon/libs/cpp/ts_codec/bit_buffer.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <util/generic/fwd.h>

namespace NSolomon::NTs {

TBuffer ParseBin(TStringBuf str);

/**
 * @return {buffer, bit length}
 */
std::pair<TBuffer, size_t> ParseBin2(TStringBuf str);

TString ToBin(const TBitBuffer& buf);
TString ToBin(const TBuffer& buf);

TString ToHex(const TBitBuffer& buf);
TString ToHex(const TBuffer& buf);

void FillRandomly(size_t max, TBitBuffer* buf);

::testing::AssertionResult IsSameBuf(const TBitBuffer& actualBuf, TStringBuf expectedBits);

} // namespace NSolomon::NTs
