#pragma once

#include <jni.h>

#include <util/generic/yexception.h>

namespace NSolomon::NJava {

class TAggrPointClass {
public:
    explicit TAggrPointClass(JNIEnv* jenv) {
        Class_ = jenv->FindClass("ru/yandex/solomon/model/point/AggrPoint");
        Y_ENSURE(Class_, "cannot find class ru/yandex/solomon/model/point/AggrPoint");

        Constructor_ = jenv->GetMethodID(Class_, "<init>", "()V");
        Y_ENSURE(Constructor_, "cannot find default constructor");

        ColumnSetField_ = GetField(jenv, "columnSet", "I");
        TsMillisField_ = GetField(jenv, "tsMillis", "J");
        ValueNumField_ = GetField(jenv, "valueNum", "D");
        ValueDenomField_ = GetField(jenv, "valueDenom", "J");
        MergeField_ = GetField(jenv, "merge", "Z");
        CountField_ = GetField(jenv, "count", "J");
        StepMillisField_ = GetField(jenv, "stepMillis", "J");
        LongValueField_ = GetField(jenv, "longValue", "J");
        SummaryInt64Field_ = GetField(jenv, "summaryInt64", "Lru/yandex/monlib/metrics/summary/SummaryInt64Snapshot;");
        SummaryDoubleField_ = GetField(jenv, "summaryDouble", "Lru/yandex/monlib/metrics/summary/SummaryDoubleSnapshot;");
        HistogramField_ = GetField(jenv, "histogram", "Lru/yandex/solomon/model/type/Histogram;");
        LogHistogramField_ = GetField(jenv, "logHistogram", "Lru/yandex/solomon/model/type/LogHistogram;");
    }

    jclass Class() const noexcept {
        return Class_;
    }

    jobject New(JNIEnv* jenv) {
        return jenv->NewObject(Class_, Constructor_);
    }

    ui32 GetColumnSet(JNIEnv* jenv, jobject obj) {
        return static_cast<ui32>(jenv->GetIntField(obj, ColumnSetField_));
    }

    void SetColumnSet(JNIEnv* jenv, jobject obj, ui32 columnSet) {
        jenv->SetIntField(obj, ColumnSetField_, static_cast<jint>(columnSet));
    }

    ui64 GetTsMillis(JNIEnv* jenv, jobject obj) {
        return static_cast<ui64>(jenv->GetLongField(obj, TsMillisField_));
    }

    void SetTsMillis(JNIEnv* jenv, jobject obj, ui64 tsMillis) {
        jenv->SetLongField(obj, TsMillisField_, static_cast<ui64>(tsMillis));
    }

    double GetValueNum(JNIEnv* jenv, jobject obj) {
        return static_cast<double>(jenv->GetDoubleField(obj, ValueNumField_));
    }

    void SetValueNum(JNIEnv* jenv, jobject obj, double valueNum) {
        jenv->SetDoubleField(obj, ValueNumField_, static_cast<jdouble>(valueNum));
    }

    ui64 GetValueDenom(JNIEnv* jenv, jobject obj) {
        return static_cast<ui64>(jenv->GetLongField(obj, ValueDenomField_));
    }

    void SetValueDenom(JNIEnv* jenv, jobject obj, ui64 valueDenom) {
        jenv->SetLongField(obj, ValueDenomField_, static_cast<jlong>(valueDenom));
    }

    bool GetMerge(JNIEnv* jenv, jobject obj) {
        return static_cast<bool>(jenv->GetBooleanField(obj, MergeField_));
    }

    void SetMerge(JNIEnv* jenv, jobject obj, bool merge) {
        jenv->SetBooleanField(obj, MergeField_, static_cast<jboolean>(merge));
    }

    ui64 GetCount(JNIEnv* jenv, jobject obj) {
        return static_cast<ui64>(jenv->GetLongField(obj, CountField_));
    }

    void SetCount(JNIEnv* jenv, jobject obj, ui64 count) {
        jenv->SetLongField(obj, CountField_, static_cast<jlong>(count));
    }

    ui64 GetStepMillis(JNIEnv* jenv, jobject obj) {
        return static_cast<ui64>(jenv->GetLongField(obj, StepMillisField_));
    }

    void SetStepMillis(JNIEnv* jenv, jobject obj, ui64 stepMillis) {
        jenv->SetLongField(obj, StepMillisField_, static_cast<jlong>(stepMillis));
    }

    i64 GetLongValue(JNIEnv* jenv, jobject obj) {
        return static_cast<i64>(jenv->GetLongField(obj, LongValueField_));
    }

    void SetLongValue(JNIEnv* jenv, jobject obj, i64 value) {
        jenv->SetLongField(obj, LongValueField_, static_cast<jlong>(value));
    }

    jobject GetSummaryInt64(JNIEnv* jenv, jobject obj) {
        return jenv->GetObjectField(obj, SummaryInt64Field_);
    }

    void SetSummaryInt64(JNIEnv* jenv, jobject obj, jobject value) {
        jenv->SetObjectField(obj, SummaryInt64Field_, value);
    }

    jobject GetSummaryDouble(JNIEnv* jenv, jobject obj) {
        return jenv->GetObjectField(obj, SummaryDoubleField_);
    }

    void SetSummaryDouble(JNIEnv* jenv, jobject obj, jobject value) {
        jenv->SetObjectField(obj, SummaryDoubleField_, value);
    }

    jobject GetHistogram(JNIEnv* jenv, jobject obj) {
        return jenv->GetObjectField(obj, HistogramField_);
    }

    void SetHistogram(JNIEnv* jenv, jobject obj, jobject value) {
        jenv->SetObjectField(obj, HistogramField_, value);
    }

    jobject GetLogHistogram(JNIEnv* jenv, jobject obj) {
        return jenv->GetObjectField(obj, LogHistogramField_);
    }

    void SetLogHistogram(JNIEnv* jenv, jobject obj, jobject value) {
        jenv->SetObjectField(obj, LogHistogramField_, value);
    }

private:
    jfieldID GetField(JNIEnv* jenv, const char* name, const char* sig) {
        jfieldID field = jenv->GetFieldID(Class_, name, sig);
        Y_ENSURE(field, "cannot find field " << name);
        return field;
    }

private:
    jclass Class_;
    jmethodID Constructor_;
    jfieldID ColumnSetField_;
    jfieldID TsMillisField_;
    jfieldID ValueNumField_;
    jfieldID ValueDenomField_;
    jfieldID MergeField_;
    jfieldID CountField_;
    jfieldID StepMillisField_;
    jfieldID LongValueField_;
    jfieldID SummaryInt64Field_;
    jfieldID SummaryDoubleField_;
    jfieldID HistogramField_;
    jfieldID LogHistogramField_;
};

} // namespace NSolomon::NJava
