#include "heap_bit_buf.h"

#include <util/generic/yexception.h>

namespace NSolomon::NJava {
namespace {

TBuffer ToBuffer(JNIEnv* jenv, jbyteArray array) {
    jbyte* data = jenv->GetByteArrayElements(array, nullptr);
    jsize size = jenv->GetArrayLength(array);
    TBuffer buffer(reinterpret_cast<const char*>(data), static_cast<size_t>(size));
    jenv->ReleaseByteArrayElements(array, data, JNI_ABORT);
    return buffer;
}

jbyteArray ToByteArray(JNIEnv* jenv, const TBuffer& buffer) {
    jbyteArray result = jenv->NewByteArray(buffer.size());
    jenv->SetByteArrayRegion(result, 0, buffer.size(), reinterpret_cast<const jbyte*>(buffer.data()));
    return result;
}

} // namespace

NTs::TBitBuffer FromHeapBitBuffer(JNIEnv* jenv, jobject bitBuf) {
    jclass clazz = jenv->FindClass("ru/yandex/solomon/codec/bits/HeapBitBuf");
    Y_ENSURE(clazz, "cannot find class ru/yandex/solomon/codec/bits/HeapBitBuf");

    auto getField = [jenv, clazz](const char* name, const char* sig) {
        jfieldID field = jenv->GetFieldID(clazz, name, sig);
        Y_ENSURE(field, "cannot get field " << name);
        return field;
    };

    jfieldID arrayField = getField("array", "[B");
    jfieldID writeIndexField = getField("writeIndex", "J");
    jfieldID readIndexField = getField("readIndex", "J");

    jobject arrayObject = jenv->GetObjectField(bitBuf, arrayField);
    jbyteArray array = *reinterpret_cast<jbyteArray*>(&arrayObject);
    jlong writeIndex = jenv->GetLongField(bitBuf, writeIndexField);
    jlong readIndex = jenv->GetLongField(bitBuf, readIndexField);

    NTs::TBitBuffer buf(ToBuffer(jenv, array));
    buf.Resize(writeIndex - readIndex);
    return buf;
}

jobject ToHeapBitBuffer(JNIEnv* jenv, NTs::TBitBuffer& buf) {
    jclass clazz = jenv->FindClass("ru/yandex/solomon/codec/bits/HeapBitBuf");
    Y_ENSURE(clazz, "cannot find class ru/yandex/solomon/codec/bits/HeapBitBuf");

    jmethodID constructor = jenv->GetMethodID(clazz, "<init>", "([BJ)V");
    Y_ENSURE(constructor, "cannot get constructor of ru/yandex/solomon/codec/bits/HeapBitBuf");

    jbyteArray array = ToByteArray(jenv, buf.Container());
    return jenv->NewObject(clazz, constructor, array, static_cast<jlong>(buf.Size()));
}

} // namespace NSolomon::NJava
