#!/bin/sh -ex

SRCS="$(find ../src -name '*Native.java')"
LIBS_DIR="../../../../libs/java"

# generate .h files
ya make ${LIBS_DIR}/ts-codec ${LIBS_DIR}/ts-model
ya tool javac11 -cp "${LIBS_DIR}/ts-codec/ts-codec.jar:${LIBS_DIR}/ts-model/ts-model.jar:." \
    -h . $SRCS

# drop created .class files
find ../src -name '*.class' -delete

# add pragma once
find . -name 'ru_*.h' | xargs -n1 sed -i '' '1i\
#pragma once
'

