package ru.yandex.solomon.ts_codec;

import ru.yandex.solomon.codec.bits.HeapBitBuf;

public class BitStreamNative {

    static {
        System.loadLibrary("ts_codec_native");
    }

    public static native boolean[] readBits(HeapBitBuf bitBuf, int offset);
    public static native byte[] readInt8(HeapBitBuf bitBuf, int offset);
    public static native int[] readInt32(HeapBitBuf bitBuf, int offset);
    public static native long[] readInt64(HeapBitBuf bitBuf, int offset);
    public static native double[] readDouble(HeapBitBuf bitBuf, int offset);
    public static native int[] readInt32Bits(HeapBitBuf bitBuf, int bits, int offset);
    public static native long[] readInt64Bits(HeapBitBuf bitBuf, int bits, int offset);
    public static native int[] readVarInt32(HeapBitBuf bitBuf, int offset);
    public static native long[] readVarInt64(HeapBitBuf bitBuf, int offset);
    public static native int[] readOnes(HeapBitBuf bitBuf, int offset);

    public static native HeapBitBuf writeBits(boolean[] values, int offset);
    public static native HeapBitBuf writeInt8(byte[] values, int offset);
    public static native HeapBitBuf writeInt32(int[] values, int offset);
    public static native HeapBitBuf writeInt64(long[] values, int offset);
    public static native HeapBitBuf writeDouble(double[] values, int offset);
    public static native HeapBitBuf writeInt32Bits(int[] values, int bits, int offset);
    public static native HeapBitBuf writeInt64Bits(long[] values, int bits, int offset);
    public static native HeapBitBuf writeVarInt32(int[] values, int offset);
    public static native HeapBitBuf writeVarInt64(long[] values, int offset);
    public static native HeapBitBuf writeOnes(int[] values, int offset);

}
