package ru.yandex.solomon.ts_codec;

import java.util.ArrayList;

import ru.yandex.solomon.codec.bits.HeapBitBuf;
import ru.yandex.solomon.codec.compress.CompressStreamFactory;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Sergey Polovko
 */
final class TsStreamJava {
    private TsStreamJava() {}

    static HeapBitBuf encode(MetricType type, int columnsMask, AggrPoint[] points) {
        var buf = new HeapBitBuf();
        try (var out = CompressStreamFactory.createOutputStream(type, columnsMask, buf, points.length)) {
            for (AggrPoint point : points) {
                out.writePoint(columnsMask, point);
            }
        }
        return buf;
    }

    static AggrPoint[] decode(MetricType type, int columnsMask, HeapBitBuf buf) {
        try (var in = CompressStreamFactory.createInputStream(type, columnsMask, buf)) {
            var points = new ArrayList<AggrPoint>();
            while (in.hasNext()) {
                AggrPoint point = new AggrPoint();
                in.readPoint(columnsMask, point);
                points.add(point);
            }
            return points.toArray(AggrPoint[]::new);
        }
    }
}
