package ru.yandex.solomon.ts_codec;

import ru.yandex.solomon.codec.bits.HeapBitBuf;
import ru.yandex.solomon.model.point.AggrPoint;

/**
 * @author Sergey Polovko
 */
public class TsStreamNative {

    static {
        System.loadLibrary("ts_codec_native");
    }

    public static native HeapBitBuf encodeDouble(int columnsMask, AggrPoint[] points);
    public static native AggrPoint[] decodeDouble(int columnsMask, HeapBitBuf bitBuf);

    public static native HeapBitBuf gaugeInt64Encode(int columnsMask, AggrPoint[] points);
    public static native AggrPoint[] gaugeInt64Decode(int columnsMask, HeapBitBuf bitBuf);

    public static native HeapBitBuf counterEncode(int columnsMask, AggrPoint[] points);
    public static native AggrPoint[] counterDecode(int columnsMask, HeapBitBuf bitBuf);

    public static native HeapBitBuf summaryInt64Encode(int columnsMask, AggrPoint[] points);
    public static native AggrPoint[] summaryInt64Decode(int columnsMask, HeapBitBuf bitBuf);

    public static native HeapBitBuf summaryDoubleEncode(int columnsMask, AggrPoint[] points);
    public static native AggrPoint[] summaryDoubleDecode(int columnsMask, HeapBitBuf bitBuf);

    public static native HeapBitBuf histogramEncode(int columnsMask, AggrPoint[] points);
    public static native AggrPoint[] histogramDecode(int columnsMask, HeapBitBuf bitBuf);

    public static native HeapBitBuf logHistogramEncode(int columnsMask, AggrPoint[] points);
    public static native AggrPoint[] logHistogramDecode(int columnsMask, HeapBitBuf bitBuf);
}
