#include "aggregation.h"

#include "error.h"

namespace NSolomon::NTsMath {

NTsModel::EAggregationFunction AggregationFunction(
        yandex::solomon::math::Aggregation aggregation,
        NTsModel::EPointType type)
{
    switch (aggregation) {
        case yandex::solomon::math::DEFAULT_AGGREGATION:
            switch (type) {
                case NTsModel::EPointType::Unknown:
                    return NTsModel::EAggregationFunction::Avg;
                case NTsModel::EPointType::DGauge:
                case NTsModel::EPointType::Counter:
                case NTsModel::EPointType::Rate:
                case NTsModel::EPointType::IGauge:
                    return NTsModel::EAggregationFunction::Max;
                case NTsModel::EPointType::Hist:
                case NTsModel::EPointType::HistRate:
                case NTsModel::EPointType::LogHist:
                    return NTsModel::EAggregationFunction::Sum;
                case NTsModel::EPointType::DSummary:
                    return NTsModel::EAggregationFunction::Last;
            }
        case yandex::solomon::math::MAX:
            return NTsModel::EAggregationFunction::Max;
        case yandex::solomon::math::MIN:
            return NTsModel::EAggregationFunction::Min;
        case yandex::solomon::math::SUM:
            return NTsModel::EAggregationFunction::Sum;
        case yandex::solomon::math::AVG:
            return NTsModel::EAggregationFunction::Avg;
        case yandex::solomon::math::LAST:
            return NTsModel::EAggregationFunction::Last;
        case yandex::solomon::math::COUNT:
            return NTsModel::EAggregationFunction::Count;
        default:
            ythrow TConfigError{} << "unknown aggregation function " << static_cast<int>(aggregation);
    }
}

bool AggregateNonScalar(NTsModel::EAggregationFunction function) {
    switch (function) {
        case NTsModel::EAggregationFunction::Min:
        case NTsModel::EAggregationFunction::Max:
        case NTsModel::EAggregationFunction::Avg:
            return false;
        case NTsModel::EAggregationFunction::Sum:
        case NTsModel::EAggregationFunction::Last:
        case NTsModel::EAggregationFunction::Count:
            return true;
        default:
            ythrow TConfigError{} << "unknown aggregation function " << static_cast<int>(function);
    }
}

} // namespace NSolomon::NTsMath
