#pragma once

#include <util/generic/yexception.h>

#include <contrib/libs/grpc/include/grpcpp/impl/codegen/status_code_enum.h>

namespace NSolomon::NTsMath {

/**
 * Base class for all exceptions that are thrown when
 */
class TException: public yexception {
public:
    virtual grpc::StatusCode Code() = 0;
};

/**
 * Logical error in operation configuration.
 */
class TConfigError: public TException {
public:
    grpc::StatusCode Code() override;
};

/**
 * Type error when executing query, i.e. an operation can't be applied to a time series of this type.
 */
class TTypeError: public TException {
public:
    grpc::StatusCode Code() override;
};

/**
 * Error with non-type constraints, i.e. an operation can't be applied to a certain value or time series.
 */
class TConstraintError: public TException {
public:
    grpc::StatusCode Code() override;
};

/**
 * Requested feature is not yet implemented.
 */
class TNotImplementedError: public TException {
public:
    grpc::StatusCode Code() override;
};

} // namespace NSolomon::NTsMath
