#pragma once

#include "time_series.h"

#include <util/generic/vector.h>

namespace NSolomon::NTsMath {

/**
 * Abstract interface for a single operation over a group of time series.
 */
class IOperation {
public:
    virtual ~IOperation() = default;

public:
    /**
     * Apply this operation.
     *
     * This method may change or invalidate contents of its argument.
     */
    virtual TVector<TTimeSeries> Apply(TVector<TTimeSeries>&& source) = 0;
};

} // namespace NSolomon::NTsMath
