#include "operation_pipeline.h"

#include <solomon/libs/cpp/ts_model/visit.h>

namespace NSolomon::NTsMath {

void TOperationPipeline::Add(THolder<IOperation> operation) {
    Operations_.push_back(std::move(operation));
}

TVector<TTimeSeriesEncoded> TOperationPipeline::Apply(TVector<TTimeSeries>&& source) {
    for (auto& operation: Operations_) {
        source = operation->Apply(std::move(source));
    }

    TVector<TTimeSeriesEncoded> res;
    res.reserve(source.size());

    for (auto& tsSrc: source) {
        auto& tsRes = res.emplace_back();
        tsRes.Labels = std::move(tsSrc.Labels);
        tsRes.Summary = std::move(tsSrc.Summary);
        tsRes.Type = tsSrc.Data->Type();
        tsRes.WindowBegin = tsSrc.Data->WindowBegin();
        tsRes.WindowEnd = tsSrc.Data->WindowEnd();

        auto genericIt = tsSrc.Data->Iterator();

        tsRes.Columns = tsSrc.Data->Columns();

        NTsModel::Visit(tsRes.Type, [&](auto traits) {
            using TPoint = typename decltype(traits)::TPoint;
            using TEncoder = typename NTsModel::TEncoder<TPoint>;

            auto& it = traits.DowncastIterator(*genericIt);
            NTs::TBitWriter writer{&tsRes.Data};
            auto encoder = TEncoder{tsRes.Columns.ToColumnSet(tsRes.Type), &writer};
            auto point = traits.MakePoint();
            while (it.NextPoint(&point)) {
                encoder.EncodePoint(point);
            }
            tsRes.NumPoints = encoder.FrameSize();
            encoder.Flush();
        });
    }

    return res;
}

} // namespace NSolomon::NTsMath
