#pragma once

#include "operation.h"

#include <util/generic/vector.h>

namespace NSolomon::NTsMath {

/**
 * Abstract interface for a single operation over a group of time series.
 */
class TOperationPipeline {
public:
    /**
     * Add an operation to the pipeline.
     */
    void Add(THolder<IOperation> operation);

    /**
     * Apply all operations to the input.
     */
    TVector<TTimeSeriesEncoded> Apply(TVector<TTimeSeries>&& source);

private:
    TVector<THolder<IOperation>> Operations_;
};

} // namespace NSolomon::NTsMath
