#include "proto.h"

#include "error.h"

#include <solomon/libs/cpp/ts_math/operations/cast.h>
#include <solomon/libs/cpp/ts_math/operations/combine.h>
#include <solomon/libs/cpp/ts_math/operations/downsampling.h>
#include <solomon/libs/cpp/ts_math/operations/top.h>

namespace NSolomon::NTsMath {

THolder<IOperation> FromProto(const yandex::solomon::math::Operation& operation) {
    if (operation.has_downsampling()) {
        return Downsampling(operation.downsampling());
    } else if (operation.has_drop_timeseries()) {
        ythrow TNotImplementedError{} << "operation 'drop timeseries' is not implemented";
    } else if (operation.has_summary()) {
        ythrow TNotImplementedError{} << "operation 'summary' is not implemented";
    } else if (operation.has_top()) {
        return Top(operation.top());
    } else if (operation.has_combine()) {
        return Combine(operation.combine());
    } else if (operation.has_cast()) {
        return Cast(operation.cast());
    }

    ythrow TConfigError{} << "unknown operation";
}

} // namespace NSolomon::NTsMath
