#include "summary.h"

namespace NSolomon::NTsMath {

NTsModel::EPointType TSummary::Type() const {
    return Type_;
}

bool TSummary::LesserThen(EAggregation aggregation, const TSummary& rhs) const {
    Y_ASSERT(CanCompare(aggregation, *this, rhs));

    if (Y_UNLIKELY(aggregation == EAggregation::DEFAULT_AGGREGATION)) {
        aggregation = DefaultAggregation(Type());
    }

    switch (aggregation) {
        case EAggregation::MAX:
            return Max() < rhs.Max();
        case EAggregation::MIN:
            return Min() < rhs.Min();
        case EAggregation::SUM:
            return Sum() < rhs.Sum();
        case EAggregation::AVG:
            return Avg() < rhs.Avg();
        case EAggregation::LAST:
            return Last() < rhs.Last();
        case EAggregation::COUNT:
            return Count() < rhs.Count();
        case EAggregation::DEFAULT_AGGREGATION:
            Y_UNREACHABLE();
        default:
            Y_FAIL("unknown aggregation %d", aggregation);
    }
}

double TSummary::Max() const {
    if (auto valueDouble = std::get_if<TValueDouble>(&Data_)) {
        return valueDouble->Max;
    } else if (auto valueInt = std::get_if<TValueInt>(&Data_)) {
        return valueInt->Max;
    } else {
        return 0;
    }
}

double TSummary::Min() const {
    if (auto valueDouble = std::get_if<TValueDouble>(&Data_)) {
        return valueDouble->Min;
    } else if (auto valueInt = std::get_if<TValueInt>(&Data_)) {
        return valueInt->Min;
    } else {
        return 0;
    }
}

double TSummary::Sum() const {
    if (auto valueDouble = std::get_if<TValueDouble>(&Data_)) {
        return valueDouble->Sum;
    } else if (auto valueInt = std::get_if<TValueInt>(&Data_)) {
        return valueInt->Sum;
    } else {
        return 0;
    }
}

double TSummary::Avg() const {
    return Sum() / Count();
}

double TSummary::Last() const {
    if (auto valueDouble = std::get_if<TValueDouble>(&Data_)) {
        return valueDouble->Last;
    } else if (auto valueInt = std::get_if<TValueInt>(&Data_)) {
        return valueInt->Last;
    } else {
        return 0;
    }
}

double TSummary::Count() const {
    return Count_;
}

//namespace {
//
//template <typename TF>
//decltype(auto) Visit(const TSummary::TValue& lhs, const TSummary::TValue& rhs, TF functor) {
//    if (lhs.index() != rhs.index()) {
//        return lhs.index() < rhs.index();
//    }
//
//    if (auto valueDouble = std::get_if<TSummary::TValueDouble>(&lhs)) {
//        return functor(*valueDouble, *std::get_if<TSummary::TValueDouble>(&rhs));
//    } else if (auto valueInt = std::get_if<TSummary::TValueInt>(&lhs)) {
//        return functor(*valueInt, *std::get_if<TSummary::TValueInt>(&rhs));
//    } else if (auto valueHist = std::get_if<TSummary::TValueHist>(&lhs)) {
//        return functor(*valueHist, *std::get_if<TSummary::TValueHist>(&rhs));
//    } else if (auto valueLogHist = std::get_if<TSummary::TValueLogHist>(&lhs)) {
//        return functor(*valueLogHist, *std::get_if<TSummary::TValueLogHist>(&rhs));
//    } else if (auto valueDSummary = std::get_if<TSummary::TValueDSummary>(&lhs)) {
//        return functor(*valueDSummary, *std::get_if<TSummary::TValueDSummary>(&rhs));
//    } else {
//        Y_UNREACHABLE();
//    }
//}
//
//bool HistLesser(const NTs::NValue::THistogram lhs, const NTs::NValue::THistogram& rhs) {
//    Y_UNUSED(lhs, rhs);
//    return false;  // TODO!
//}
//
//bool LogHistLesser(const NTs::NValue::TLogHistogram lhs, const NTs::NValue::TLogHistogram& rhs) {
//    Y_UNUSED(lhs, rhs);
//    return false;  // TODO!
//}
//
//bool DSummaryLesser(const NTs::NValue::TSummaryDouble lhs, const NTs::NValue::TSummaryDouble & rhs) {
//    Y_UNUSED(lhs, rhs);
//    return false;  // TODO!
//}
//
//} // namespace
//
//bool TSummary::LesserThan(const TSummary& rhs, yandex::solomon::math::Aggregation by) {
//    switch (by) {
//        case yandex::solomon::math::MAX:
//            return MaxLesserThan(rhs);
//        case yandex::solomon::math::MIN:
//            return MinLesserThan(rhs);
//        case yandex::solomon::math::SUM:
//            return SumLesserThan(rhs);
//        case yandex::solomon::math::AVG:
//            return AvgLesserThan(rhs);
//        case yandex::solomon::math::LAST:
//            return LastLesserThan(rhs);
//        case yandex::solomon::math::COUNT:
//            return CountLesserThan(rhs);
//        default:
//            Y_FAIL("unsupported comparison");
//    }
//}
//
//bool TSummary::CountLesserThan(const TSummary& rhs) const {
//    struct TComparator {
//        bool operator()(const TSummary::TValueDouble& lhs, const TSummary::TValueDouble& rhs) {
//            return lhs.Count < rhs.Count;
//        }
//        bool operator()(const TSummary::TValueInt& lhs, const TSummary::TValueInt& rhs) {
//            return lhs.Count < rhs.Count;
//        }
//        bool operator()(const TSummary::TValueHist& lhs, const TSummary::TValueHist& rhs) {
//            return lhs.Count < rhs.Count;
//        }
//        bool operator()(const TSummary::TValueLogHist& lhs, const TSummary::TValueLogHist& rhs) {
//            return lhs.Count < rhs.Count;
//        }
//        bool operator()(const TSummary::TValueDSummary& lhs, const TSummary::TValueDSummary& rhs) {
//            return lhs.Count < rhs.Count;
//        }
//    };
//
//    return Visit(Data, rhs.Data, TComparator{});
//}
//
//bool TSummary::SumLesserThan(const TSummary& rhs) const {
//    struct TComparator {
//        bool operator()(const TSummary::TValueDouble& lhs, const TSummary::TValueDouble& rhs) {
//            return lhs.Sum < rhs.Sum;
//        }
//        bool operator()(const TSummary::TValueInt& lhs, const TSummary::TValueInt& rhs) {
//            return lhs.Sum < rhs.Sum;
//        }
//        bool operator()(const TSummary::TValueHist& lhs, const TSummary::TValueHist& rhs) {
//            return HistLesser(lhs.Sum, rhs.Sum);
//        }
//        bool operator()(const TSummary::TValueLogHist& lhs, const TSummary::TValueLogHist& rhs) {
//            return LogHistLesser(lhs.Sum, rhs.Sum);
//        }
//        bool operator()(const TSummary::TValueDSummary& lhs, const TSummary::TValueDSummary& rhs) {
//            return DSummaryLesser(lhs.Sum, rhs.Sum);
//        }
//    };
//
//    return Visit(Data, rhs.Data, TComparator{});
//}
//
//bool TSummary::MinLesserThan(const TSummary& rhs) const {
//    struct TComparator {
//        bool operator()(const TSummary::TValueDouble& lhs, const TSummary::TValueDouble& rhs) {
//            return lhs.Min < rhs.Min;
//        }
//        bool operator()(const TSummary::TValueInt& lhs, const TSummary::TValueInt& rhs) {
//            return lhs.Min < rhs.Min;
//        }
//        bool operator()(const TSummary::TValueHist& lhs, const TSummary::TValueHist& rhs) {
//            return false;
//        }
//        bool operator()(const TSummary::TValueLogHist& lhs, const TSummary::TValueLogHist& rhs) {
//            return false;
//        }
//        bool operator()(const TSummary::TValueDSummary& lhs, const TSummary::TValueDSummary& rhs) {
//            return false;
//        }
//    };
//
//    return Visit(Data, rhs.Data, TComparator{});
//}
//
//bool TSummary::MaxLesserThan(const TSummary& rhs) const {
//    struct TComparator {
//        bool operator()(const TSummary::TValueDouble& lhs, const TSummary::TValueDouble& rhs) {
//            return lhs.Max < rhs.Max;
//        }
//        bool operator()(const TSummary::TValueInt& lhs, const TSummary::TValueInt& rhs) {
//            return lhs.Max < rhs.Max;
//        }
//        bool operator()(const TSummary::TValueHist& lhs, const TSummary::TValueHist& rhs) {
//            return false;
//        }
//        bool operator()(const TSummary::TValueLogHist& lhs, const TSummary::TValueLogHist& rhs) {
//            return false;
//        }
//        bool operator()(const TSummary::TValueDSummary& lhs, const TSummary::TValueDSummary& rhs) {
//            return false;
//        }
//    };
//
//    return Visit(Data, rhs.Data, TComparator{});
//}
//
//bool TSummary::AvgLesserThan(const TSummary& rhs) const {
//    struct TComparator {
//        bool operator()(const TSummary::TValueDouble& lhs, const TSummary::TValueDouble& rhs) {
//            return lhs.GetAvg() < rhs.GetAvg();
//        }
//        bool operator()(const TSummary::TValueInt& lhs, const TSummary::TValueInt& rhs) {
//            return lhs.GetAvg() < rhs.GetAvg();
//        }
//        bool operator()(const TSummary::TValueHist& lhs, const TSummary::TValueHist& rhs) {
//            return false;
//        }
//        bool operator()(const TSummary::TValueLogHist& lhs, const TSummary::TValueLogHist& rhs) {
//            return false;
//        }
//        bool operator()(const TSummary::TValueDSummary& lhs, const TSummary::TValueDSummary& rhs) {
//            return false;
//        }
//    };
//
//    return Visit(Data, rhs.Data, TComparator{});
//}
//
//bool TSummary::LastLesserThan(const TSummary& rhs) const {
//    struct TComparator {
//        bool operator()(const TSummary::TValueDouble& lhs, const TSummary::TValueDouble& rhs) {
//            return lhs.Last < rhs.Last;
//        }
//        bool operator()(const TSummary::TValueInt& lhs, const TSummary::TValueInt& rhs) {
//            return lhs.Last < rhs.Last;
//        }
//        bool operator()(const TSummary::TValueHist& lhs, const TSummary::TValueHist& rhs) {
//            return HistLesser(lhs.Last, rhs.Last);
//        }
//        bool operator()(const TSummary::TValueLogHist& lhs, const TSummary::TValueLogHist& rhs) {
//            return LogHistLesser(lhs.Last, rhs.Last);
//        }
//        bool operator()(const TSummary::TValueDSummary& lhs, const TSummary::TValueDSummary& rhs) {
//            return DSummaryLesser(lhs.Last, rhs.Last);
//        }
//    };
//
//    return Visit(Data, rhs.Data, TComparator{});
//}

} // namespace NSolomon::NTsMath
