#pragma once

#include <solomon/libs/cpp/labels/interned.h>
#include <solomon/libs/cpp/ts_model/iterable.h>
#include <solomon/libs/cpp/ts_model/point_columns.h>

#include <library/cpp/monlib/metrics/metric_type.h>

#include <util/generic/maybe.h>

namespace NSolomon::NTsMath {

struct TSummary {
    // TODO
    void* Opaque;
};

/**
 * A single time series upon which we perform our operations.
 */
struct TTimeSeries {
    /**
     * Labels associated with this time series.
     * This may be absent if it wasn't provided in an input, or this time series is a result of combining operation.
     */
    TMaybe<NLabels::TInternedLabels> Labels;

    /**
     * Cached line summary.
     */
    TMaybe<TSummary> Summary;

    /**
     * This series data.
     */
    THolder<NTsModel::IIterable> Data;
};

/**
 * A single time series upon which we perform our operations.
 */
struct TTimeSeriesEncoded {
    /**
     * Labels associated with this time series.
     * This may be absent if it wasn't provided in an input, or this time series is a result of combining operation.
     */
    TMaybe<NLabels::TInternedLabels> Labels;

    /**
     * Cached line summary.
     */
    TMaybe<TSummary> Summary;

    /**
     * Number of points in this time series.
     */
    size_t NumPoints;

    /**
     * Type of this time series.
     */
    NTsModel::EPointType Type{NTsModel::EPointType::Unknown};

    /**
     * Beginning of the time window that constraints points in this time series (typically a downsampling window).
     */
    TInstant WindowBegin;

    /**
     * Ending of the time window that constraints points in this time series (typically a downsampling window).
     */
    TInstant WindowEnd;

    /**
     * Columns that were used to encode this time series.
     */
    NTsModel::TPointColumns Columns;

    /**
     * This series data.
     */
    NTs::TBitBuffer Data;
};

} // namespace NSolomon::NTsMath
