#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/libs/cpp/ts_model/iterable_list.h>
#include <solomon/libs/cpp/ts_model/iterator_decode.h>
#include <solomon/libs/cpp/ts_model/testlib/testlib.h>
#include <solomon/libs/cpp/ts_math/operation_pipeline.h>

using namespace NSolomon::NTsMath;
using namespace NSolomon::NTsModel;
using namespace NSolomon::NTs;

TEST(OperationPipeline, Empty) {
    TOperationPipeline pipeline;

    TVector<TGaugePoint> m1 = {
        Gauge("2020-01-01T00:00:10", 10, 1),
        Gauge("2020-01-01T00:00:15", 11, 1),
        Gauge("2020-01-01T00:00:20", 8, 1),
    };
    NSolomon::NLabels::TInternedLabels m1l{{1, 1}};

    TVector<TDSummaryPoint> m2 = {
        DSummary("2020-01-01T00:00:10", 2, 8, 3, 5, 3),
        DSummary("2020-01-01T00:00:15", 1, 4, 4, 4, 4),
        DSummary("2020-01-01T00:00:20", 3, 8, 2, 3, 3),
        DSummary("2020-01-01T00:00:25", 2, 1, 0, 1, 0),
    };
    NSolomon::NLabels::TInternedLabels m2l{{1, 2}};

    TVector<TTimeSeries> source;
    source.emplace_back() = {
        .Labels = m1l,
        .Data = MakeHolder<TListIterable<TGaugePoint>>(m1)
    };
    source.emplace_back() = {
        .Labels = m2l,
        .Data = MakeHolder<TListIterable<TDSummaryPoint>>(m2)
    };

    auto result = pipeline.Apply(std::move(source));

    ASSERT_EQ(result.size(), 2u);

    {
        auto& val = result[0];
        EXPECT_EQ(val.NumPoints, 3u);
        EXPECT_EQ(val.Type, EPointType::DGauge);
        EXPECT_EQ(val.Labels, m1l);
        ExpectIteratorsEq(
            TDecodeIterator<TGaugePoint>{NSolomon::NTs::TDoubleTsDecoder{
                val.Columns.ToColumnSet(val.Type), val.Data}},
            TListIterator{m1});
    }

    {
        auto& val = result[1];
        EXPECT_EQ(val.NumPoints, 4u);
        EXPECT_EQ(val.Type, EPointType::DSummary);
        EXPECT_EQ(val.Labels, m2l);
        ExpectIteratorsEq(
            TDecodeIterator<TDSummaryPoint>{NSolomon::NTs::TSummaryDoubleTsDecoder{
                val.Columns.ToColumnSet(val.Type), val.Data}},
            TListIterator{m2});
    }
}
