#pragma once

#include "aggregator_sum.h"
#include "point_traits.h"

namespace NSolomon::NTsModel {

/**
 * Aggregate points by adding their values together.
 */
template <typename TPoint>
class TAvgAggregator final: public IAggregator<TPoint> {
    static_assert(
        TPointTraits<TPoint>::IsScalar,
        "'avg' aggregation function is not supported for this type of point");

public:
    void Add(const TPoint& point) override {
        Sum.Add(point);
    }

    void Add(const NTs::TVariantPoint& point) {
        Sum.Add(point);
    }

    TPoint Finish() override {
        i64 count = Sum.Count();
        TPoint res = Sum.Finish();
        if (count > 0) {
            if constexpr (std::is_same_v<TPoint, TGaugePoint>) {
                res.Num /= count;
            } else {
                res.Value /= count;
            }
        }
        return res;
    }

    EAggregationFunction Function() const override {
        return EAggregationFunction::Avg;
    }

    i64 Count() const override {
        return Sum.Count();
    }

    void Reset() override {
        Sum.Reset();
    }

public:
    TSumAggregator<TPoint> Sum;
};

} // namespace NSolomon::NTsModel
