#pragma once

#include "aggregator.h"

namespace NSolomon::NTsModel {

/**
 * Aggregate points by counting them.
 */
template <typename TPoint>
class TCountAggregator final: public TAggregator<TPoint, TIGaugePoint> {
public:
    void Add(const TPoint& point) override {
        this->AddAggr(point);
    }

    void Add(const NTs::TVariantPoint& point) {
        this->AddAggr(point);
    }

    TIGaugePoint Finish() override {
        TIGaugePoint res;
        res.Value = this->Count_;
        this->FillAggr(&res);
        this->ResetAggr();
        return res;
    }

    void Reset() override {
        this->ResetAggr();
    }

    EAggregationFunction Function() const override {
        return EAggregationFunction::Count;
    }
};

} // namespace NSolomon::NTsModel
