#pragma once

#include "aggregator.h"
#include "merge.h"

namespace NSolomon::NTsModel {

/**
 * Aggregate points by keeping the last one.
 */
template <typename TPoint>
class TLastAggregator final: public TAggregator<TPoint> {
public:
    void Add(const TPoint& point) override {
        this->AddAggr(point, true);
        State = point; // TODO: accept `point` by rvalue ref and move?
    }

    void Add(const NTs::TVariantPoint& point) {
        this->AddAggr(point, true);
        State = point.Get<typename TPoint::TValue>(); // TODO: accept `point` by rvalue ref and move?
    }

    TPoint Finish() override {
        TPoint res;
        static_cast<typename TPoint::TValue&>(res) = std::move(State);
        this->FillAggr(&res);
        this->Reset();
        return res;
    }

    EAggregationFunction Function() const override {
        return EAggregationFunction::Last;
    }

    void Reset() override {
        State = {};
        this->ResetAggr();
    }

public:
    typename TPoint::TValue State = {};
};

} // namespace NSolomon::NTsModel
