#pragma once

#include "aggregator.h"
#include "point_traits.h"

namespace NSolomon::NTsModel {

/**
 * Aggregate points by keeping a maximum value.
 */
template <typename TPoint>
class TMaxAggregator final: public TAggregator<TPoint> {
    static_assert(
        TPointTraits<TPoint>::IsScalar,
        "'max' aggregation function is not supported for this type of point");

public:
    void Add(const TPoint& point) override {
        if (this->Count_ == 0 || TPointTraits<TPoint>::Lt(State, point)) {
            this->AddAggr(point, /* setTime = */ true);
            State = point;
        } else {
            this->AddAggr(point);
        }
    }

    void Add(const NTs::TVariantPoint& point) {
        if (this->Count_ == 0 || TPointTraits<TPoint>::Lt(State, point.Get<typename TPoint::TValue>())) {
            this->AddAggr(point, /* setTime = */ true);
            State = point.Get<typename TPoint::TValue>();
        } else {
            this->AddAggr(point);
        }
    }

    TPoint Finish() override {
        TPoint res;
        static_cast<typename TPoint::TValue&>(res) = State;
        this->FillAggr(&res);
        this->Reset();
        return res;
    }

    EAggregationFunction Function() const override {
        return EAggregationFunction::Max;
    }

    void Reset() override {
        State = {};
        this->ResetAggr();
    }

public:
    typename TPoint::TValue State = {};
};

} // namespace NSolomon::NTsModel
