#pragma once

#include "iterable.h"
#include "iterator_list.h"

namespace NSolomon::NTsModel {

/**
 * Iterable over points from a container.
 */
template <typename TPoint, typename TContainer = TVector<TPoint>>
class TListIterable: public IIterable {
public:
    TListIterable(
            TContainer points,
            TInstant windowBegin = TInstant::Zero(),
            TInstant windowEnd = TInstant::Max(),
            TPointColumns columns = ~TPointColumns{})
        : Points_(std::move(points))
        , WindowBegin_{windowBegin}
        , WindowEnd_{windowEnd}
        , Columns_{columns}
    {
    }

public:
    EPointType Type() const override {
        return TPoint::Type;
    }

    TPointColumns Columns() const override {
        return Columns_;
    }

    THolder<IGenericIterator> Iterator() const override {
        return MakeHolder<TListIterator<TPoint, TContainer>>(Points_);
    }

    TInstant WindowBegin() const override {
        return WindowBegin_;
    }

    TInstant WindowEnd() const override {
        return WindowEnd_;
    }

private:
    TContainer Points_;
    TInstant WindowBegin_;
    TInstant WindowEnd_;
    TPointColumns Columns_;
};

template <typename TPoint, typename... TArgs, template <typename, typename...> typename TContainer>
TListIterable(TContainer<TPoint, TArgs...>) -> TListIterable<TPoint, TContainer<TPoint, TArgs...>>;

} // namespace NSolomon::NTsModel
